<?php include_once("../includes/config.php"); ?>
<div class="formLayout">
<form action="?page=Search_Clients" method="post" />
<input type="text" name="key_word" value="<?php echo $_POST['key_word']; ?>">
<input name="submit" type="submit" value="Search" id="button" />    
</form>
</div>
    
<br />
<br />
<br />

<?php
    // Assuming you have established a PDO connection earlier and assigned it to the variable $pdo
    global $db1;
    $sql = "SELECT *,
        (SELECT license_code FROM license WHERE client_id = tbl_clients.Id LIMIT 1) AS LicenseCode,
        (SELECT COUNT(*) FROM visas_1444 WHERE client_id = tbl_clients.Id AND `type` <> 3) AS v1444,
        (SELECT COUNT(*) FROM passports_1444 WHERE client_id = tbl_clients.Id) AS p1444,
        (SELECT COUNT(*) FROM visas_1444 WHERE client_id = tbl_clients.Id AND `type` = 3) AS e1444,
        (SELECT COUNT(*) FROM authumra_visas.visa_number WHERE user_id =authumra_offline2017.tbl_clients.Id) AS pv1444, 
        (SELECT stop_at FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS credit,
        (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS last_access
        FROM tbl_clients 
        WHERE CompanyName like :companyname
        ORDER BY (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) DESC";

    $stmt = $db1->prepare($sql);
    
    
    $stmt->bindValue(':companyname', '%' . $_POST['key_word'] . '%');
    $stmt->execute();
    
    if ($stmt === false) {
        // Handle the error appropriately
        echo "Query error: " . $stmt->errorInfo()[2];
        // You can also log the error or perform other actions as needed 
    } else {
        // Process the result set
        $count = $stmt->rowCount();
    
        $color1 = "#F3F3F3";   // GRAY
        $color2 = "#FFFFFF";  // WHITE
        $row_count = 0;
    
        if ($count == 0) {
            echo "
            <div class='failed'>
                <img src='../images/error_icon.png' width='16' height='16' alt='Successfully' />
                Sorry! No Result Found
            </div>";
        }
    
        if ($count > 0) {
            echo "<div class='formLayout'>";
            echo "Result <strong>($count)</strong>";
            echo "<table width='100%' border='1' bordercolor='#CCCCCC'  align='left' cellpadding='0' cellspacing='0'>
                <tr>
                    <th bgcolor='$color1'>Company Name</th>
                    <th bgcolor='$color1'>License Code</th>
                    <th bgcolor='$color1'>Package</th>
                    <th bgcolor='$color1'>Print 1444</th>
                    <th bgcolor='$color1'>Passports 1444</th>
                    <th bgcolor='$color1'>Visas 1444</th>
                    <th bgcolor='$color1'>Enjaz 1444</th>
                    <th bgcolor='$color1'>Credit</th>
                    <th bgcolor='$color1'>Last Access</th>
                    <th bgcolor='$color1'>Edit</th>
                    <th bgcolor='$color1'>Delete</th>
                </tr>";
    
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $row_color = ($row_count % 2) ? $color1 : $color2;
                $credit = $row['credit'] - $row['p1444'];
                echo "<tr align='center' bgcolor=$row_color>";
                echo "<td align='center' bgcolor=$row_color>" . $row['CompanyName'] . "</td>";
                echo "<td align='left' bgcolor=$row_color>" . $row['LicenseCode'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $row['credit'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $row['pv1444'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $row['p1444'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $row['v1444'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $row['e1444'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $credit . "</td>";
                echo "<td align='center' bgcolor=$row_color>" . $row['last_access'] . "</td>";
                echo "<td align='center' bgcolor=$row_color>
                    <a href='?page=Edit_Client&id={$row['Id']}'>
                        <img src=../images/edit.gif width=12 height=18 border=0 alt=Edit title='Edit' />
                    </a>
                </td>";
                echo "<td align='center'>
                    <a href=#>
                        <img src='../images/delete.gif' width='15' height='15' alt='Delete' title='Delete' border='0' />
                    </a>
                </td>";
                echo "</tr>";
                $row_count++;
            }
    
            echo "</table>";
            echo "</div>";
        }
    }
?>

    <!-- ========== DELETE CLIENT  ======================== -->
    <script src="../includes/js/Delete_Client.js" type="text/javascript"></script>
    <!-- ================================================== -->