<?php
// Add local copy of the required db.php functions
// This file will replace the remote version

// Sample of the original code based on what we saw
function process_request($values) {
    // Some code...
    
    $wtu = 1;
    if (($version >= '1.4177') ) {
        $tawaf = 1;
    } else {
        $tawaf = 0;
    }
    $gama = 1;
    $hajj = 1;
    $barcode = 1;
    
    // Default values
    $feeding_center = 0;
    $enjaz_feeding_center = 0;
    $umrah_feeding_center = 0;
    $enjaz_payment = 0;
    
    // Get client-specific settings from database
    try {
        $stmt = $GLOBALS['dbh']->prepare("SELECT free_license, b2c_license, enjaz_feeding_center, umrah_feeding_center, enjaz_payment 
                                          FROM tbl_clients 
                                          WHERE Id = :client_id");
        $stmt->bindParam(':client_id', $client_id);
        $stmt->execute();
        
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $free_license = $row['free_license'];
            $b2c_license = $row['b2c_license'];
            $enjaz_feeding_center = $row['enjaz_feeding_center'];
            $umrah_feeding_center = $row['umrah_feeding_center'];
            $enjaz_payment = $row['enjaz_payment'];
        }
    } catch (PDOException $e) {
        // Fallback to hardcoded values if database query fails
        logAdd("Database query failed: " . $e->getMessage());
        
        // Use hardcoded values as fallback
        if ($license == "36D8C8-7312C6-D21C5C-C39C78" ) {
            $feeding_center = 1;
            $enjaz_feeding_center = 1;
            $umrah_feeding_center = 1;
            $enjaz_payment = 1;
        }
        if (($license == "6348F0-E636E7-7E1C5C-463C90") ||
            ($license == "48908C-73C62C-7E8CB8-D7E478")) {
            $enjaz_feeding_center = 1;
            $enjaz_payment = 1;
        }
        if (($license == "C6D8DC-B81258-938C45-D754F0") ||         
            ($license == "09D878-5CB42C-FC00CF-7DB430")) {
            $enjaz_feeding_center = 1;  
        }
    }
    
    $license_limit = $license_limit - get_visa_count($client_id);
    $validuntil = $timestamp + 36000;
    //give random hours of work without request. as float datetime
    logAdd('Limit : ' . $license_limit);
    $result_access = "|$offline_id|$country|$barcode|$company_name|$wristband|$ministry|$bau|$wtu|$tawaf|$gama|$license_limit|$hajj|$validuntil|";
    
    // Update the result_info string to include the new fields
    $result_info = "$cloud_database|$cloud_username|$cloud_password|$ftp_password|$ftp_username|$mofa_username|$mofa_password|$free_license|$b2c_license|$feeding_center|$enjaz_feeding_center|$umrah_feeding_center|$enjaz_payment|END";
    
    $result_message = '';
    logAdd($company_name);
    logAdd($version);
    logAdd($country);
    
    // Return values according to the original function's logic
    return array(
        'access' => $result_access,
        'info' => $result_info,
        'message' => $result_message
    );
}
?> 