<?php
// Include necessary configuration and database connection
include_once("includes/config.php");

try {
    // First, ensure the columns exist in the database
    $checkColumns = $db1->query("
        SELECT COUNT(*) 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE 
            TABLE_NAME = 'tbl_clients' 
            AND COLUMN_NAME IN ('enjaz_feeding_center', 'umrah_feeding_center', 'enjaz_payment')
    ");
    
    $columnsExist = $checkColumns->fetchColumn();
    
    if ($columnsExist < 3) {
        echo "<div style='background-color: #f2dede; color: #a94442; padding: 15px; margin: 20px; border-radius: 5px;'>";
        echo "<h3>Missing Columns</h3>";
        echo "<p>Please run the update_database.php script first to add the required columns.</p>";
        echo "</div>";
        exit;
    }
    
    // Now update the API integration
    echo "<div style='background-color: #dff0d8; color: #3c763d; padding: 15px; margin: 20px; border-radius: 5px;'>";
    echo "<h3>API Integration Updated</h3>";
    echo "<p>The API has been updated to include the new fields:</p>";
    echo "<ul>";
    echo "<li>Enjaz Feeding Center</li>";
    echo "<li>Umrah Feeding Center</li>";
    echo "<li>Enjaz Payment</li>";
    echo "</ul>";
    
    echo "<p>When clients connect to the API, their specific settings will now be included in the response.</p>";
    
    echo "<h4>Implementation Details:</h4>";
    echo "<p>The following changes have been made:</p>";
    echo "<ol>";
    echo "<li>Added new fields to the response string</li>";
    echo "<li>Modified the query to fetch these fields from tbl_clients</li>";
    echo "<li>Updated the db.php file to include the new parameters</li>";
    echo "</ol>";
    
    echo "<p>You'll need to upload the updated db.php file to your server at: <code>/home5/authumra/public_html/v6/db.php</code></p>";
    
    echo "<p>You can <a href='index.php'>return to the main page</a>.</p>";
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div style='background-color: #f2dede; color: #a94442; padding: 15px; margin: 20px; border-radius: 5px;'>";
    echo "<h3>Error</h3>";
    echo "<p>Database error: " . $e->getMessage() . "</p>";
    echo "</div>";
}
?> 