<?php
class DataBaseObjects {
    private $pdo;
    
    public function __construct() {
        global $db1;
        $this->pdo = $db1;
    }
    
    public function insert($table, $data) {
        $columns = implode(', ', array_keys($data));
        $placeholders = ':' . implode(', :', array_keys($data));
        
        $sql = "INSERT INTO $table ($columns) VALUES ($placeholders)";
        $stmt = $this->pdo->prepare($sql);
        
        foreach ($data as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        
        $stmt->execute();
        return $this->pdo->lastInsertId();
    }
    
    public function select($table, $where = [], $columns = '*') {
        $sql = "SELECT $columns FROM $table";
        
        if (!empty($where)) {
            $conditions = [];
            foreach ($where as $key => $value) {
                $conditions[] = "$key = :$key";
            }
            $sql .= " WHERE " . implode(' AND ', $conditions);
        }
        
        $stmt = $this->pdo->prepare($sql);
        
        if (!empty($where)) {
            foreach ($where as $key => $value) {
                $stmt->bindValue(":$key", $value);
            }
        }
        
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function selectAll($table, $columns = '*') {
        $sql = "SELECT $columns FROM $table ORDER BY name ASC";
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function update($table, $data, $where) {
        $setClause = [];
        foreach (array_keys($data) as $key) {
            $setClause[] = "$key = :set_$key";
        }
        
        $whereClause = [];
        foreach (array_keys($where) as $key) {
            $whereClause[] = "$key = :where_$key";
        }
        
        $sql = "UPDATE $table SET " . implode(', ', $setClause) . " WHERE " . implode(' AND ', $whereClause);
        $stmt = $this->pdo->prepare($sql);
        
        foreach ($data as $key => $value) {
            $stmt->bindValue(":set_$key", $value);
        }
        
        foreach ($where as $key => $value) {
            $stmt->bindValue(":where_$key", $value);
        }
        
        return $stmt->execute();
    }
    
    public function delete($table, $where) {
        $whereClause = [];
        foreach (array_keys($where) as $key) {
            $whereClause[] = "$key = :$key";
        }
        
        $sql = "DELETE FROM $table WHERE " . implode(' AND ', $whereClause);
        $stmt = $this->pdo->prepare($sql);
        
        foreach ($where as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        
        return $stmt->execute();
    }
}
?>
