<?php include_once("../includes/config.php"); ?>
<div class="container mt-3">
<form action="?page=Search_Clients" method="post" class="d-flex">
<input type="text" name="key_word" class="form-control" placeholder="Search..." value="<?php echo $_POST['key_word'];?>">
<button type="submit" class="btn btn-primary ms-2">Search</button>
</form>
</div>
    
<br />
<br />
<br />

<?php
    // Assuming you have established a PDO connection earlier and assigned it to the variable $pdo
    global $db1;
/*    $sql = "SELECT *,
        (SELECT license_code FROM license WHERE client_id = tbl_clients.Id LIMIT 1) AS LicenseCode,
        (SELECT COUNT(*) FROM visas_1444 WHERE client_id = tbl_clients.Id AND `type` <> 3) AS v1444,
        (SELECT COUNT(*) FROM passports_1444 WHERE client_id = tbl_clients.Id) AS p1444,
        (SELECT COUNT(*) FROM visas_1444 WHERE client_id = tbl_clients.Id AND `type` = 3) AS e1444,
        (SELECT COUNT(*) FROM authumra_visas.visa_number WHERE user_id =authumra_offline2017.tbl_clients.Id) AS pv1444, 
        (SELECT stop_at FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS credit,
        (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS last_access
        FROM tbl_clients 
        WHERE CompanyName like :companyname
        ORDER BY (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) DESC";
*/
$table_suffix = 1446; // Replace this number as needed
$passports = "passports_".$table_suffix."_2024";
$sql = "SELECT *,
    (SELECT license_code FROM license WHERE client_id = tbl_clients.Id LIMIT 1) AS LicenseCode,
    (SELECT COUNT(*) FROM visas_" . $table_suffix . " WHERE client_id = tbl_clients.Id AND `type` <> 3) AS v" . $table_suffix . ",
    (SELECT COUNT(*) FROM $passports WHERE client_id = tbl_clients.Id) AS p" . $table_suffix . ",
    (SELECT COUNT(*) FROM visas_" . $table_suffix . " WHERE client_id = tbl_clients.Id AND `type` = 3) AS e" . $table_suffix . ",
    (SELECT COUNT(*) FROM authumra_visas.visa_number WHERE user_id = authumra_offline2017.tbl_clients.Id) AS pv" . $table_suffix . ",
    (SELECT stop_at FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS credit,
    (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS last_access
    FROM tbl_clients 
    WHERE CompanyName like :companyname
    ORDER BY (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) DESC";

    $stmt = $db1->prepare($sql);
    
    
    $stmt->bindValue(':companyname', '%' . $_POST['key_word'] . '%');
    $stmt->execute();
    
    if ($stmt === false) {
        // Handle the error appropriately
        echo "Query error: " . $stmt->errorInfo()[2];
        // You can also log the error or perform other actions as needed 
    } else {
        // Process the result set
        $count = $stmt->rowCount();
    
        $color1 = "#F3F3F3";   // GRAY
        $color2 = "#FFFFFF";  // WHITE
        $row_count = 0;
    
        if ($count == 0) {
            echo "
            <div class='failed'>
                <img src='../images/error_icon.png' width='16' height='16' alt='Successfully' />
                Sorry! No Result Found
            </div>";
        }
    
        if ($count > 0) {
            echo "<div class='container mt-3'>";  // Bootstrap container
            echo "<div class='table-responsive'>";  // Responsive table wrapper
            echo "Result <strong>($count)</strong>";
            echo "<table class='table table-striped table-bordered table-hover'>";  // Bootstrap table classes
            echo "<thead class='thead-dark'>";  // Bootstrap thead class
            echo "<tr>";
            echo "<th scope='col'>Company Name</th>";
            echo "<th scope='col'>License Code</th>";
            echo "<th scope='col'>Package</th>";
            echo "<th scope='col'>Print $table_suffix</th>";
            echo "<th scope='col'>Passports $table_suffix</th>";
            echo "<th scope='col'>Visas $table_suffix</th>";
            echo "<th scope='col'>Enjaz $table_suffix</th>";
            echo "<th scope='col'>Credit</th>";
            echo "<th scope='col'>Last Access</th>";
            echo "<th scope='col'>Edit</th>";                
            echo "</tr>";
            echo "</thead>";  // End of Bootstrap thead
            echo "<tbody>";  // Start of tbody
            
            $row_count = 0;  // Initialize row count
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<tr class='text-center'>";  // Center align all columns
                echo "<td>" . htmlspecialchars($row['CompanyName'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['LicenseCode'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['credit']) . "</td>";
                echo "<td>" . htmlspecialchars($row["pv$table_suffix"]) . "</td>";
                echo "<td>" . htmlspecialchars($row["p$table_suffix"]) . "</td>";
                echo "<td>" . htmlspecialchars($row["v$table_suffix"]) . "</td>";
                echo "<td>" . htmlspecialchars($row["e$table_suffix"]) . "</td>";
                echo "<td>" . htmlspecialchars($row['credit'] - $row["p$table_suffix"]) . "</td>";
                echo "<td>" . htmlspecialchars($row['last_access']) . "</td>";
                echo "<td>
                <a href='?page=Edit_Client&id={$row['Id']}' class='btn btn-outline-secondary'>
                    <i class='bi bi-pencil'></i>
                </a>
                </td>"; 
                echo "</tr>";
                $row_count++;
            }
            
            echo "</tbody>";  // End of tbody
            echo "</table>";
            echo "</div>";  // End of table-responsive
            echo "</div>";  // End of container
                    }
    }
?>

    <!-- ========== DELETE CLIENT  ======================== -->
    <script src="../includes/js/Delete_Client.js" type="text/javascript"></script>
    <!-- ================================================== -->