<?php include_once("../includes/config.php"); ?>
<!-- ========== AJAX Get_Clients  ===================== -->
 <script src="includes/js/Get_Clients.js?v=<?php echo time(); ?>" type="text/javascript"></script>
 <!-- Clipboard Copy Script -->
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('License Code copied to clipboard: ' + text);
    }, function() {
        alert('Failed to copy License Code.');
    });
}
</script>
<!-- Flashing Red Effect CSS -->
<style>
    .container {
        max-width: 1200px;
        padding: 2rem;
    }
    .search-section {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 2rem;
    }
    .form-control {
        border-radius: 25px;
        padding: 0.75rem 1.5rem;
        border: 1px solid #e0e0e0;
        transition: all 0.3s ease;
    }
    .form-control:focus {
        box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        border-color: #dc3545;
    }
    select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%23333' viewBox='0 0 16 16'%3E%3Cpath d='M8 12l-6-6h12z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        padding-right: 2.5rem !important;
    }
    .country-section {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 2rem;
    }
    #txtHint {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
    .flashing-red {
        animation: flashing 1.5s ease-in-out infinite alternate;
        font-weight: 600;
    }
    @keyframes flashing {
        0% { color: #dc3545; }
        100% { color: #495057; }
    }
    .btn {
        padding: 0.75rem 1.5rem;
        border-radius: 25px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-primary {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        border: none;
        box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
    }
    .alert {
        border-radius: 15px;
        padding: 1rem 1.5rem;
        margin-bottom: 1.5rem;
        border: none;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }
</style>

<!-- ================================================== -->	
<div class="container mt-4">
    <!-- Success Message -->
    <?php Message("Client_Deleted_Successfully", "alert alert-success", "success_icon.png", "Client Successfully Deleted "); ?>

    <!-- Search Section -->
    <div class="search-section">
        <form action="" method="get" class="d-flex flex-column gap-2">
            <input type="text" name="search" class="form-control" placeholder="Search clients...">
            <button type="submit" class="btn btn-primary w-100">Search</button>
        </form>
    </div>

    <!-- Country Section -->
    <div class="country-section">
        <div class="mb-3">
            <label for="Country" class="form-label fw-bold">Country:</label>
            <select name="Country" id="Country" class="form-control" onChange="ShowClients(this.value)">
                <option value=''>--- Select Country ---</option>
                <option value='all'>All</option>
                <?php Get_Countries(); ?>
            </select>
        </div>
    </div>

    <!-- Clients Result Section -->
    <div id="txtHint">
        <?php if(isset($_GET['search'])): ?>
            <?php Search_Clients_Edit($_GET['search']); ?>
        <?php else: ?>
            <b>Clients info will be listed here.</b>
        <?php endif; ?>
    </div>
</div>

<?php
function Search_Clients_Edit($search_term) {
    global $db1;
    
    $sql = "SELECT *,
        (SELECT license_code FROM license WHERE client_id = tbl_clients.Id LIMIT 1) AS LicenseCode,
        (SELECT stop_at FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS credit,
        (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS last_access
        FROM tbl_clients 
        WHERE CompanyName LIKE :companyname
        ORDER BY (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) DESC";

    $stmt = $db1->prepare($sql);
    $stmt->bindValue(':companyname', '%' . $search_term . '%');
    $stmt->execute();
    
    if ($stmt === false) {
        echo "Query error: " . $stmt->errorInfo()[2];
        return;
    }
    
    $count = $stmt->rowCount();
    
    if ($count == 0) {
        echo "<div class='alert alert-warning'>No clients found matching '$search_term'</div>";
        return;
    }
    
    echo "<div class='alert alert-info'>Found $count client(s) matching '$search_term'</div>";
    echo "<div class='table-responsive'>";
    echo "<table class='table table-striped table-bordered table-hover'>";
    echo "<thead class='thead-dark'>";
    echo "<tr>";
    echo "<th scope='col'>Company Name</th>";
    echo "<th scope='col'>License Code</th>";
    echo "<th scope='col'>Credit</th>";
    echo "<th scope='col'>Last Access</th>";
    echo "<th scope='col'>Actions</th>";                
    echo "</tr>";
    echo "</thead>";
    echo "<tbody>";
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr class='text-center'>";
        echo "<td>" . htmlspecialchars($row['CompanyName'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['LicenseCode'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['credit'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['last_access'] ?? '') . "</td>";
        echo "<td>
        <a href='?page=edit_client&id={$row['Id']}' class='btn btn-outline-secondary btn-sm me-1'>
            <i class='bi bi-pencil'></i> Edit
        </a>
        <button onclick='copyToClipboard(\"" . htmlspecialchars($row['LicenseCode'] ?? '') . "\")' class='btn btn-outline-info btn-sm'>
            <i class='bi bi-clipboard'></i> Copy License
        </button>
        </td>"; 
        echo "</tr>";
    }
    
    echo "</tbody>";
    echo "</table>";
    echo "</div>";
}
?>
    <!-- ========== DELETE CLIENT  ======================== -->
    <script src="../includes/js/Delete_Client.js" type="text/javascript"></script>
    <!-- ================================================== -->