<?php
include_once("includes/config.php");
include_once("includes/DataBaseObjects.php");

$dbo = new DataBaseObjects();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    if ($name !== '') {
        try {
            $dbo->insert('tbl_account_managers', [
                'name' => $name,
                'email' => ($email !== '' ? $email : null),
                'phone' => ($phone !== '' ? $phone : null),
            ]);
            header("Location: ".SITE_URL."?page=account_managers&status=added_successfully");
            exit;
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    } else {
        $error = 'Name is required';
    }
}

$managers = $dbo->selectAll('tbl_account_managers', 'id, name, email, phone, created_at');
?>
<div class="container-fluid px-4">
    <h1 class="mt-4">Account Managers</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
        <li class="breadcrumb-item active">Account Managers</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-user-tie me-1"></i>
            Add Account Manager
        </div>
        <div class="card-body">
            <?php if (!empty($_GET['status']) && $_GET['status']==='added_successfully'): ?>
                <div class="alert alert-success">Added successfully</div>
            <?php endif; ?>
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            <form method="post">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="form-floating mb-3">
                            <input type="text" name="name" class="form-control" id="am_name" placeholder="Name" required>
                            <label for="am_name">Name</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-floating mb-3">
                            <input type="email" name="email" class="form-control" id="am_email" placeholder="Email">
                            <label for="am_email">Email</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-floating mb-3">
                            <input type="text" name="phone" class="form-control" id="am_phone" placeholder="Phone">
                            <label for="am_phone">Phone</label>
                        </div>
                    </div>
                </div>
                <button class="btn btn-primary" type="submit">Add</button>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <i class="fas fa-list me-1"></i>
            Managers List
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($managers as $m): ?>
                            <tr>
                                <td><?php echo (int)$m['id']; ?></td>
                                <td><?php echo htmlspecialchars($m['name']); ?></td>
                                <td><?php echo htmlspecialchars($m['email']); ?></td>
                                <td><?php echo htmlspecialchars($m['phone']); ?></td>
                                <td><?php echo htmlspecialchars($m['created_at']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php

Message("User_Deleted_Successfully","success","success_icon.png","User Successfully Deleted "); 

require("../includes/config.php"); 
$query = "SELECT * FROM tbl_users";
$stmt = $db1->query($query);
$count = $stmt->rowCount();

$color1 = "#F3F3F3";   // GRAY
$color2 = "#FFFFFF";  // WHITE
$row_count = 0;

echo "Result <strong>($count)</strong>";
echo "<table width='100%' border='1' bordercolor='#CCCCCC' align='left' cellpadding='0' cellspacing='0'>";
echo "<tr>
        <th bgcolor='$color1'>User Name</th>
        <th bgcolor='$color1'>Type</th>
        <th bgcolor='$color1'>Edit</th>
        <th bgcolor='$color1'>Delete</th>
    </tr>";

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $row_count++;
    $row_color = ($row_count % 2 == 0) ? $color1 : $color2;

    echo "<tr>";
    echo "<td align='center' bgcolor='$row_color'>" . $row['User_Name'] . "</td>";
    echo "<td align='center' bgcolor='$row_color'>" . $row['Type'] . "</td>";
    echo "<td align='center' bgcolor='$row_color'>
        <a href='?page=Edit_User&id={$row['id']}'>
            <img src='../images/edit.gif' width='12' height='18' border='0' alt='Edit' title='Edit' />
        </a>
    </td>";
    echo "<td align='center' bgcolor='$row_color'>
        <a href='#' onClick=\"deleteImage('{$row['id']}'); return false;\">
            <img src='../images/delete.gif' width='15' height='15' alt='Delete' title='Delete' border='0' />
        </a>
    </td>";
    echo "</tr>";
}

echo "</table>";
//***************************************************************************************************************
?>

<script type='text/javascript' language='javascript'>
function deleteImage(x){
var conf = confirm('Are you sure you want to Delete this User?');
if(conf == true){
location = 'delete.php?page=delete_user&id='+x
}
}
</script>

