<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Print all POST data for debugging
/*if (!empty($_POST)) {
    echo "<pre>";
    echo "POST Data:\n";
    print_r($_POST);
    echo "</pre>";
}*/

// Start output buffering and session
ob_start();
session_start();

// Include required files with error checking
$requiredFiles = [
    "includes/config.php",
    "includes/DataBaseObjects.php",
    "post_variables.php"
];

foreach ($requiredFiles as $file) {
    if (!file_exists($file)) {
        die("Error: Required file '$file' is missing");
    }
    include_once($file);
}

// Database connection error handling
try {
    if (!isset($db1)) {
        throw new Exception("Database connection not established");
    }
} catch (Exception $e) {
    die("Database Error: " . $e->getMessage());
}

// Function to handle database errors
function handleDBError($stmt) {
    $errorInfo = $stmt->errorInfo();
    $errorMsg = "Database Error: " . ($errorInfo[2] ?? 'Unknown error');
    error_log($errorMsg); // Log to server error log
    return $errorMsg;
}

// ======================== ENCODING USERNAME AND PASS ==============================
function encode($string, $key) {
    $key = sha1($key);
    $strLen = strlen($string);
    $keyLen = strlen($key);
    $hash = '';
    $j = 0;
    
    for ($i = 0; $i < $strLen; $i++) {
        $ordStr = ord(substr($string, $i, 1));
        if ($j == $keyLen) {
            $j = 0;
        }
        $ordKey = ord(substr($key, $j, 1));
        $j++;
        $hash .= strrev(base_convert(dechex($ordStr + $ordKey), 16, 36));
    }
    
    return $hash;
}
//=================================================================================

if ($_GET['page'] == "add_hajj_user") {
    if (!empty($hajj_user_name)) {
        $query = "INSERT INTO `tbl_eghajj_users` (`hajj_user`) VALUES (?)";
        $stmt = $db1->prepare($query);
        if ($stmt->execute([$hajj_user_name])) {
            header("Location: ".SITE_URL."?page=add_hajj_user&status=added_successfully");
        } else {
            echo "Error: " . $stmt->errorInfo()[2];
        }
    }
}

// ======================== ADD CLIENT QUERY ======================================
if ($_GET['page'] == "add_client") {
    try {
        $Start_Balance = empty($Start_Balance) ? null : (int)$Start_Balance;
        $safa_ea_id = empty($safa_ea_id) ? null : (int)$safa_ea_id;

        $sql = "INSERT INTO tbl_clients 
                (id, CompanyName, PersonIncharge, Country, City, Telephone, Email, connection_id, MSN, Purchase_Date, Renew_Date, Start_Balance, Message, safa_ea_id, max_license, free_license, Barcode_Enabled, alert_enabled, license_enabled)
                VALUES
                (NULL, :CompanyName, :PersonIncharge, :Country, :City, :Telephone, :Email, :connection_id, :MSN, :PurchaseDate, :RenewDate, :StartBalance, :Message, :safaEaId, 2, :free_license, :barcode, :alert_enabled, :license_enabled)";
        
        $stmt = $db1->prepare($sql);
        if (!$stmt) {
            throw new Exception("Failed to prepare statement: " . print_r($db1->errorInfo(), true));
        }
        
        $result = $stmt->execute([
            ':CompanyName' => $Company_name,
            ':PersonIncharge' => $Person_Incharge,
            ':Country' => $Country,
            ':City' => $City,
            ':Telephone' => $Telephone,
            ':Email' => $Email,
            ':connection_id' => $Connection,
            ':MSN' => $MSN,
            ':PurchaseDate' => $Purchase_Date,
            ':RenewDate' => $Renew_Date,
            ':StartBalance' => $Start_Balance,
            ':Message' => $Message,
            ':safaEaId' => $safa_ea_id,
            ':free_license' => $free_license,
            ':barcode' => $barcode,
            ':alert_enabled' => $alert_enabled,
            ':license_enabled' => $license_enabled
        ]);

        if (!$result) {
            throw new Exception(handleDBError($stmt));
        }

        $last_id = $db1->lastInsertId();
        if (!$last_id) {
            throw new Exception("Failed to get last insert ID");
        }

        // Inserting data into tbl_clients_applications
        $appData = [
            [1, $Available_Safa, $Block_Safa],
            [2, $Available_Enjaz, $Block_Enjaz],
            [3, $Available_Scan, $Block_Scan],
            [4, $Available_Offline, $Block_Offline],
            [6, $Available_Offline, $Block_Offline]
        ];

        $sql = "INSERT INTO tbl_clients_applications 
                (id, App_Id, Client_id, availability, Blocked, Time_stamp)
                VALUES (NULL, :AppId, :ClientId, :Availability, :Blocked, NOW())";
        $stmt = $db1->prepare($sql);

        foreach ($appData as $data) {
            $stmt->execute([
                ':AppId' => $data[0],
                ':ClientId' => $last_id,
                ':Availability' => $data[1],
                ':Blocked' => $data[2]
            ]);
        }

        header("Location: ".SITE_URL."?page=edit_client&id=$last_id");
        exit();

    } catch (Exception $e) {
        error_log("Error in add_client: " . $e->getMessage());
        echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
    }
}

// ======================== EDIT CLIENT QUERY ======================================
if ($_GET['page'] == "edit_client") {
    try {
        $id = $_GET['id'] ?? null;
        if (!$id) {
            throw new Exception("No client ID provided");
        }

        // Validate and sanitize inputs
        $safa_ea_id = empty($safa_ea_id) ? null : filter_var($safa_ea_id, FILTER_VALIDATE_INT);
        $Start_Balance = $Start_Balance === null ? 0 : filter_var($Start_Balance, FILTER_VALIDATE_INT);
        $alert_enabled = isset($_POST['alert_enabled']) ? 1 : 0;
        $license_enabled = isset($_POST['license_enabled']) ? 1 : 0;
        
        $query = "UPDATE `tbl_clients` SET  
            `CompanyName` = :CompanyName,
            `PersonIncharge` = :PersonIncharge,
            `Country` = :Country,
            `City` = :City,
            `Telephone` = :Telephone,
            `Email` = :Email,
            `connection_id` = :connection_id,
            `MSN` = :MSN,
            `Purchase_Date` = :Purchase_Date,
            `Renew_Date` = :Renew_Date,
            `Barcode_Enabled` = :barcode,
            `free_license` = :free_license,
            `Start_Balance` = :Start_Balance,
            `max_license` = :max_license,
            `Message` = :Message,
            `safa_ea_id` = :safa_ea_id,
            `alert_enabled` = :alert_enabled,
            `license_enabled` = :license_enabled
            WHERE `id` = :id";

        $stmt = $db1->prepare($query);
        if (!$stmt) {
            throw new Exception("Failed to prepare statement: " . print_r($db1->errorInfo(), true));
        }

        $result = $stmt->execute([
            ':CompanyName' => $Company_name,
            ':PersonIncharge' => $Person_Incharge,
            ':Country' => $Country,
            ':City' => $City,
            ':Telephone' => $Telephone,
            ':Email' => $Email,
            ':connection_id' => $Connection,
            ':MSN' => $MSN,
            ':Purchase_Date' => $Purchase_Date,
            ':Renew_Date' => $Renew_Date,
            ':barcode' => $barcode,
            ':free_license' => $free_license,
            ':Start_Balance' => $Start_Balance,
            ':max_license' => $max_license,
            ':Message' => $Message,
            ':safa_ea_id' => $safa_ea_id,
            ':alert_enabled' => $alert_enabled,
            ':license_enabled' => $license_enabled,
            ':id' => $id
        ]);

        if (!$result) {
            throw new Exception(handleDBError($stmt));
        }

        // Fetch all available applications from the tbl_applications table
        $query = "SELECT id, Application_Name FROM tbl_applications WHERE visible = 1";
        $stmt = $db1->prepare($query);
        $stmt->execute();
        $applications = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Loop through the applications to dynamically update based on the input fields
        foreach ($applications as $app) {
            $appName = strtoupper($app['Application_Name']);
            
            // Create dynamic variable names for each application
            $availableVar = "Available_{$appName}";
            $blockVar = "Block_{$appName}";
            $limitVar = "{$appName}_Limit";
            
            // Get the values from the input (assuming they are in POST request)
            $available = isset($_POST[$availableVar]) ? $_POST[$availableVar] : 0;
            $block = isset($_POST[$blockVar]) ? $_POST[$blockVar] : 0;
            $limit = isset($_POST[$limitVar]) && $_POST[$limitVar] !== '' ? (int)$_POST[$limitVar] : 0;


            // Update the tbl_clients_applications for this application
            $query = "UPDATE tbl_clients_applications 
                      SET availability = :available, Blocked = :blocked, Stop_At = :limit
                      WHERE App_Id = :app_id AND Client_id = :client_id";
            $stmt = $db1->prepare($query);
            $stmt->bindValue(':available', $available);
            $stmt->bindValue(':blocked', $block);
            $stmt->bindValue(':limit', $limit);
            $stmt->bindValue(':app_id', $app['id']);
            $stmt->bindValue(':client_id', $id);
            
            if ($stmt->execute()) {
                // Application update successful
            }
        }

        header("Location: ".SITE_URL."?page=edit_client&id=$id");        
        exit();

    } catch (Exception $e) {
        error_log("Error in edit_client: " . $e->getMessage());
        echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
    }
}

// Other blocks for `add_user`, `Edit_Dongle`, etc., should follow the same approach: using prepared statements and proper error handling.
// ======================== ADD USER ======================================
if ($_GET['page'] == "add_user") {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $email = $_POST['email'];

    // Encode password using the encode function
    $encodedPassword = encode($password, "secret_key");

    $query = "INSERT INTO `tbl_users` (username, password, email, created_at) 
              VALUES (:username, :password, :email, NOW())";
    $stmt = $db1->prepare($query);
    if ($stmt->execute([
        ':username' => $username,
        ':password' => $encodedPassword,
        ':email' => $email
    ])) {
        header("Location: ".SITE_URL."?page=add_user&status=added_successfully");
    } else {
        echo "Error: " . $stmt->errorInfo()[2];
    }
}

// ======================== EDIT DONGLE QUERY ==============================
if ($_GET['page'] == "Edit_Dongle") {
    $id = $_GET['id'];
	$stop_at = !empty($_POST['Stop_At']) ? intval($_POST['Stop_At']) : null;

    $query = "UPDATE `tbl_dongles` SET 
              `Barcode` = :barcode, 
              `Activated` = :activated, 
              `Date_Activated` = :date_activated,
              `License_ID` = :license_id,
              `Stop_At` = :stop_at
              WHERE `id` = :id";

    $stmt = $db1->prepare($query);
    $stmt->execute([
        ':barcode' => $Barcode,
        ':activated' => $Activated,
        ':date_activated' => $Date_Activated,
        ':license_id' => $License_ID,
        ':stop_at' => $stop_at,
        ':id' => $id
    ]);

    header("Location: ".SITE_URL."?page=Edit_Dongle&id=$id");
}

// ======================== DELETE CLIENT ==================================
if ($_GET['page'] == "delete_Client") {
    $id = $_GET['id'];

    $query = "DELETE FROM `tbl_clients` WHERE `id` = :id";
    $stmt = $db1->prepare($query);
    if ($stmt->execute([':id' => $id])) {
        header("Location: ".SITE_URL."?page=manage_clients&status=deleted_successfully");
    } else {
        echo "Error: " . $stmt->errorInfo()[2];
    }
}

// ======================== LIST CLIENTS ===================================
if ($_GET['page'] == "list_Clients") {
    $query = "SELECT * FROM `tbl_clients`";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $clients = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($clients as $client) {
        echo "<tr>
                <td>{$client['CompanyName']}</td>
                <td>{$client['PersonIncharge']}</td>
                <td>{$client['Country']}</td>
                <td>{$client['City']}</td>
                <td>{$client['Telephone']}</td>
                <td>{$client['Email']}</td>
                <td><a href='?page=edit_client&id={$client['id']}'>Edit</a></td>
                <td><a href='?page=delete_Client&id={$client['id']}' onclick='return confirm(\"Are you sure?\")'>Delete</a></td>
            </tr>";
    }
}

// ======================== DELETE DONGLE ==================================
if ($_GET['page'] == "delete_Dongle") {
    $id = $_GET['id'];

    $query = "DELETE FROM `tbl_dongles` WHERE `id` = :id";
    $stmt = $db1->prepare($query);
    if ($stmt->execute([':id' => $id])) {
        header("Location: ".SITE_URL."?page=manage_dongles&status=deleted_successfully");
    } else {
        echo "Error: " . $stmt->errorInfo()[2];
    }
}

// ======================== LIST DONGLES ===================================
if ($_GET['page'] == "list_Dongles") {
    $query = "SELECT * FROM `tbl_dongles`";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $dongles = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($dongles as $dongle) {
        echo "<tr>
                <td>{$dongle['Barcode']}</td>
                <td>{$dongle['Activated']}</td>
                <td>{$dongle['Date_Activated']}</td>
                <td><a href='?page=Edit_Dongle&id={$dongle['id']}'>Edit</a></td>
                <td><a href='?page=delete_Dongle&id={$dongle['id']}' onclick='return confirm(\"Are you sure?\")'>Delete</a></td>
            </tr>";
    }
}

// ======================== USER LOGIN =====================================
if ($_POST['action'] == "login") {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $encodedPassword = encode($password, "secret_key");

    $query = "SELECT * FROM `tbl_users` WHERE `username` = :username AND `password` = :password";
    $stmt = $db1->prepare($query);
    $stmt->execute([
        ':username' => $username,
        ':password' => $encodedPassword
    ]);

    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        header("Location: ../admin/dashboard.php");
    } else {
        echo "Invalid username or password!";
    }
}

// ======================== USER LOGOUT ====================================
if ($_GET['action'] == "logout") {
    session_destroy();
    header("Location: ../admin/login.php");
}

// ======================== DASHBOARD STATS ==================================
if ($_GET['page'] == "dashboard") {
    // Example dashboard stats query
    $query = "SELECT COUNT(*) as total_clients FROM tbl_clients";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $total_clients = $stmt->fetch(PDO::FETCH_ASSOC)['total_clients'];

    echo "<h3>Total Clients: $total_clients</h3>";
}
?>
